import { Color } from 'three';

export const BIOME_COLORS = {
  DEEP_OCEAN: new Color(0x000080),
  OCEAN: new Color(0x006994),
  SHALLOW_OCEAN: new Color(0x44aadd), // Lighter cyan for shallow water/shore
  BEACH: new Color(0xE6C288), // Sandy
  GRASSLAND: new Color(0x567d46), // Green
  FOREST: new Color(0x2d5a27), // Darker Green
  DESERT: new Color(0xC2B280), // Tan
  MOUNTAIN_BASE: new Color(0x5a5a5a), // Grey
  SNOW: new Color(0xffffff),
  ICE: new Color(0xe0f6ff)
};

export function getBiomeData(height, latitude, moisture) {
    // height: normalized -1 to 1 (where 0 is sea level)
    // latitude: 0 to 1 (abs)
    // moisture: 0 to 1

    let color;
    let name;

    if (height < 0) {
        // Underwater
        color = BIOME_COLORS.OCEAN; // Usually hidden by ocean mesh, but good for seabed
        name = "Ocean Floor";
        if (height < -0.5) {
            color = BIOME_COLORS.DEEP_OCEAN;
        } else if (height > -0.05) {
            color = BIOME_COLORS.SHALLOW_OCEAN; // Shoreline effect
        }
    } else {
        // Land
        if (latitude > 0.8) {
            color = BIOME_COLORS.ICE;
            name = "Polar Ice";
        } else {
            if (height > 0.6) {
                color = BIOME_COLORS.SNOW;
                name = "Snowy Peaks";
            } else if (height > 0.3) {
                // Mountain base / Hills
                if (latitude > 0.6) {
                    color = BIOME_COLORS.SNOW;
                    name = "Tundra";
                } else {
                    color = BIOME_COLORS.MOUNTAIN_BASE;
                    name = "Mountain";
                }
            } else {
                // Lowlands
                if (height < 0.05) {
                    color = BIOME_COLORS.BEACH;
                    name = "Beach";
                } else {
                    // Check moisture/lat for Deserts vs Grass
                    // Artificial "Desert belt" around 30 degrees? (0.3 - 0.5 lat?)
                    // Or just noise.
                    
                    if (moisture < 0.3 || (latitude > 0.2 && latitude < 0.4 && moisture < 0.6)) {
                        color = BIOME_COLORS.DESERT;
                        name = "Desert";
                    } else {
                        if (moisture > 0.6) {
                            color = BIOME_COLORS.FOREST;
                            name = "Forest";
                        } else {
                            color = BIOME_COLORS.GRASSLAND;
                            name = "Grassland";
                        }
                    }
                }
            }
        }
    }

    return { color, name };
}
