import { createNoise3D } from 'simplex-noise';

const noise3D = createNoise3D();

export function fbm(x, y, z, { octaves = 6, persistence = 0.5, lacunarity = 2.0, scale = 1.0 } = {}) {
  let total = 0;
  let frequency = scale;
  let amplitude = 1;
  let maxValue = 0;  // Used for normalizing result to 0.0 - 1.0

  for (let i = 0; i < octaves; i++) {
    total += noise3D(x * frequency, y * frequency, z * frequency) * amplitude;
    maxValue += amplitude;
    amplitude *= persistence;
    frequency *= lacunarity;
  }

  return (total / maxValue) + 0.5; // Normalize to roughly 0-1 range? Actually simplex is -1 to 1.
  // total/maxValue is -1 to 1.
  // +0.5 makes it -0.5 to 1.5? No.
  // Let's just return the raw FBM value often, but 0-1 is easier for mapping.
  // Simplex is approx -1 to 1.
  // So total / maxValue is -1 to 1.
  // (val + 1) / 2 is 0 to 1.
}

export function simpleNoise(x, y, z, scale = 1.0) {
    return noise3D(x * scale, y * scale, z * scale);
}
